' Setup type of chip and tell compiler the clock speed in Mhz
Device = 18F43K20           
Clock = 8

' Setup config options                      
Config FOSC = INTIO67       '
Config MCLRE = OFF
Config boren = off  ' this is a must if using coin cell batteries! the microcontroller always resets itself otherwise!

' import library's
Include "RandGen2.bas"

' Register Setup

' Constant Arrays
Const GrayCode(16) As Byte = (%00000000, %00000001, %00000011, %00000010, %00000110, %00000111, %00000101, %00000100, %00001100, %00001101, %00001111, %00001110, %00001010, %00001011, %00001001, %00001000)         
Const POVMessage(600) As Byte = (%00000100, %00000100, %00000100, %00001000, %00001000, %00010000, %00010000, %00010000, %00010000, %00001000, %00001000, %00000100, %00000110, %00000010, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000010, %00000100, %00001000, %00011000, %00110000, %00100000, %00100000, %00100000, %00100000, %00100000, %00110000, %00011000, %00001100, %00000010, %00000010, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000010, %00000110, %00000100, %00001000, %00011000, %00110000, %00100000, %00100000, %00100000, %00100000, %00100000, %00100000, %00100000, %00110000, %00011000, %00001100, %00000010, %00000011, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000011, %00000110, %00000100, %00001000, %00011000, %00110000, %00100000, %00100000, %00100000, %00100000, %00100000, %00110000, %00001000, %00000100, %00000010, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000010, %00000110, %00001000, %00010000, %00110000, %00100000, %00100000, %00100000, %00100000, %00100000, %00010000, %00011000, %00001100, %00000110, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000010, %00000110, %00001000, %00011000, %00010000, %00100000, %00100000, %00100000, %00100000, %00100000, %00100000, %00100000, %00010000, %00001000, %00001100, %00000110, %00000010, %00000010, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000011, %00000010, %00000100, %00001000, %00011000, %00010000, %00010000, %00010000, %00010000, %00010000, %00011000, %00001100, %00000100, %00000010, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000010, %00000110, %00001000, %00010000, %00100000, %00100000, %00100000, %00100000, %00010000, %00011000, %00001000, %00000100, %00000010, %00000001, %00000001, %00000001, %00000001, %00000001, %00000001, %00000011, %00000110, %00001100, %00011000, %00010000, %00010000, %00010000, %00010000, %00010000, %00010000, %00011000, %00001100, %00000111, %00000001, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00110000, %00100001, %00111111, %00111111, %00100001, %00110000, %00000000, %00100001, %00111111, %00111111, %00001000, %00111111, %00111111, %00100001, %00000000, %00100001, %00111111, %00111111, %00101001, %00101001, %00110011, %00000000, %00000000, %00000000, %00100001, %00111111, %00111111, %00100001, %00100001, %00111111, %00011110, %00000000, %00100001, %00111111, %00111111, %00100001, %00000000, %00011110, %00111111, %00100001, %00100111, %00110111, %00000100, %00000000, %00100001, %00111111, %00111111, %00100001, %00000000, %00100001, %00111111, %00111111, %00100100, %00111111, %00011011, %00000001, %00100000, %00111110, %00111111, %00000001, %00100001, %00111110, %00100000, %00000000, %00100001, %00111111, %00111111, %00100001, %00000011, %00000000, %00100001, %00111111, %00111111, %00101001, %00101001, %00110011, %00000000, %00000000, %00000000, %00100001, %00111111, %00111111, %00100100, %00111111, %00011011, %00000001, %00100000, %00111110, %00111111, %00000001, %00100001, %00111110, %00100000, %00000000, %00100001, %00111111, %00111111, %00100001, %00000011, %00000000, %00100001, %00111111, %00111111, %00101001, %00101001, %00110011, %00000000, %00011001, %00111101, %00101101, %00101111, %00100110, %00000000, %00111101, %00111101, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000, %00111110, %01000001, %01101001, %01000101, %01000101, %01101001, %01000001, %00111110, %00000000, %00000000, %00000000, %00000000)

' Default button debounce 
Const BtnDebounceTime = 10000

' Port Setup
' buttons first
Dim LogicInputA As PORTB.1
Dim LogicInputB As PORTB.2
Dim LogicSelect As PORTB.3
Dim FlipFlopSJTD As PORTB.4
Dim FlipFlopClock As PORTB.5
Dim FlipFlopRK As PORTB.6
Dim FlipFlopSelect As PORTB.7
Dim CounterUp As PORTA.1
Dim CounterDown As PORTA.0

' Now the LED's
Dim LogicInputALed As PORTA.2
Dim LogicInputBLed As PORTA.3
Dim NOTGateLED As PORTA.4
Dim ORGateLED As PORTA.5
Dim ANDGateLED As PORTA.6
Dim XORGateLED As PORTA.7
Dim NORGateLED As PORTE.0
Dim NANDGateLED As PORTE.1
Dim XNORGateLED As PORTE.2
Dim LogicGatesXLED As PORTC.0
Dim FlipFlopSJTDLED As PORTC.1
Dim FlipFlopClockLED As PORTC.2
Dim FlipFlopRKLED As PORTC.3
Dim SRFlipFlopLED As PORTC.4
Dim JKFlipFlopLED As PORTC.5
Dim TFlipFlopLED As PORTD.0
Dim DFlipFlopLED As PORTD.1
Dim FlipFlopQLED As PORTD.2
Dim FlipFlopNOTQLED As PORTD.3
Dim Counter8LED As PORTD.4
Dim Counter4LED As PORTD.5
Dim Counter2LED As PORTD.6
Dim Counter1LED As PORTD.7

' Variable arrays

' variables
Dim x As LongWord
Dim ButtonDebounce As Word
Dim ButtonsEnabled As Boolean
Dim WhichMode As Byte
Dim WhichLogicGate As Byte
Dim WhichFlipFlop As Byte
Dim CounterCount As Byte
Dim LogicInputAPressed As Boolean
Dim LogicInputBPressed As Boolean
Dim LogicSelectPressed As Boolean
Dim FlipFlopSJTDPressed As Boolean
Dim FlipFlopClockPressed As Boolean
Dim FlipFlopRKPressed As Boolean
Dim FlipFlopSelectPressed As Boolean
Dim CounterUpPressed As Boolean
Dim CounterDownPressed As Boolean
Dim ClockEdge As Boolean
Dim LogicLEDs As LongWord
Dim TempByte As Byte
Dim SparkleDelay As Byte
Dim ShiftRegisterBuffer As Byte ' can only actually show 7 bits
Dim WhichPOVMessage As Byte
Dim DiceRolling As Boolean
Dim DiceSpeed As Byte
Dim DiceSpeedSaved As Byte
Dim DiceNumber As Byte
Dim GameSpeed As Word
Dim GameSpeedSaved As Byte
Dim GameLevel As Byte
Dim GameGoingUp As Boolean
Dim GameLEDPosition As Byte 
Dim LogicInput0 As Byte 
Dim LogicInput1 As Byte
Dim LogicAnswer As Byte 

'Interrupts

' Sub Routines
Sub DoButtonDebounce()
    If ButtonDebounce <> 0 Then
        Dec(ButtonDebounce)
    Else
        ButtonsEnabled = true
    EndIf
End Sub

Sub DoLogicGates()
    ' check the change gate button
    DoButtonDebounce 
    If LogicSelect = 1 And LogicSelectPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicSelectPressed = true
        Inc(WhichLogicGate)
        LogicInputALed = 0
        LogicInputBLed = 0
        If WhichLogicGate > 6 Then
            WhichLogicGate = 0
        EndIf
    ElseIf LogicSelect = 0 Then
        LogicSelectPressed = false
    EndIf
    ' check input A button
    If LogicInputA = 1 And LogicInputAPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputAPressed = true
        If LogicInputALed = 0 Then
            LogicInputALed = 1
        Else
            LogicInputALed = 0
        EndIf
    ElseIf LogicInputA = 0 Then
        LogicInputAPressed = false
    EndIf
    ' check input B button
    If LogicInputB = 1 And LogicInputBPressed = false And WhichLogicGate <> 0 And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputBPressed = true
        If LogicInputBLed = 0 Then
            LogicInputBLed = 1
        Else
            LogicInputBLed = 0
        EndIf
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf
    ' Now output the results
    Select WhichLogicGate
        Case 0
            If LogicInputALed = 0 Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf    
            NOTGateLED = 1
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0
        Case 1
            If LogicInputALed = 1 Or LogicInputBLed = 1 Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf
            NOTGateLED = 0
            ORGateLED = 1
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 2
            If LogicInputALed = 1 And LogicInputBLed = 1 Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 1
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 3
            If (LogicInputALed = 0 And LogicInputBLed = 1) Or (LogicInputALed = 1 And LogicInputBLed = 0) Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 1
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 4
            If LogicInputALed = 1 Or LogicInputBLed = 1 Then
                LogicGatesXLED = 0
            Else
                LogicGatesXLED = 1
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 1
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 5
            If LogicInputALed = 1 And LogicInputBLed = 1 Then
                LogicGatesXLED = 0
            Else
                LogicGatesXLED = 1
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 1
            XNORGateLED = 0 
        Case 6
            If (LogicInputALed = 0 And LogicInputBLed = 1) Or (LogicInputALed = 1 And LogicInputBLed = 0) Then
                LogicGatesXLED = 0
            Else
                LogicGatesXLED = 1
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 1
    End Select    
End Sub

Sub DoFlipFlops()
    DoButtonDebounce
    ' check the change flip flop button
    If FlipFlopSelect = 1 And FlipFlopSelectPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        FlipFlopSelectPressed = true
        Inc(WhichFlipFlop)
        FlipFlopQLED = 0  
        FlipFlopNOTQLED = 1
        FlipFlopSJTDLED = 0
        FlipFlopRKLED = 0
        If WhichFlipFlop > 3 Then
            WhichFlipFlop = 0
        EndIf
    ElseIf FlipFlopSelect = 0 Then
        FlipFlopSelectPressed = false
    EndIf
    ' check input SJTD button
    If FlipFlopSJTD = 1 And FlipFlopSJTDPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        FlipFlopSJTDPressed = true
        If FlipFlopSJTDLED = 0 Then
            FlipFlopSJTDLED = 1
        Else
            FlipFlopSJTDLED = 0
        EndIf
    ElseIf FlipFlopSJTD = 0 Then
        FlipFlopSJTDPressed = false
    EndIf
    ' check input RK button
    If FlipFlopRK = 1 And FlipFlopRKPressed = false And WhichFlipFlop < 2 And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false  ' only do this one for the SR and JK flip flops
        FlipFlopRKPressed = true
        If FlipFlopRKLED = 0 Then
            FlipFlopRKLED = 1
        Else
            FlipFlopRKLED = 0
        EndIf
    ElseIf FlipFlopRK = 0 Then
        FlipFlopRKPressed = false
    EndIf
    ' check input Clock button
    If FlipFlopClock = 1 And FlipFlopClockPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false 
        FlipFlopClockPressed = true
        FlipFlopClockLED = 1
        ClockEdge = true
    ElseIf FlipFlopClock = 0 Then
        FlipFlopClockPressed = false
        FlipFlopClockLED = 0
    EndIf
    ' Now output the results
    Select WhichFlipFlop
        Case 0
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                If FlipFlopSJTDLED = 0 And FlipFlopRKLED = 0 Then
                    ' don't do anything because it is no change!
                ElseIf FlipFlopSJTDLED = 0 And FlipFlopRKLED = 1 Then
                    FlipFlopQLED = 0
                    FlipFlopNOTQLED = 1
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 0 Then
                    FlipFlopQLED = 1
                    FlipFlopNOTQLED = 0
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 1 Then
                    FlipFlopQLED = 0
                    FlipFlopNOTQLED = 0
                EndIf
            EndIf 
            SRFlipFlopLED = 1
            JKFlipFlopLED = 0
            TFlipFlopLED = 0
            DFlipFlopLED = 0
        Case 1
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                If FlipFlopSJTDLED = 0 And FlipFlopRKLED = 0 Then
                    ' don't do anything because it is no change!
                ElseIf FlipFlopSJTDLED = 0 And FlipFlopRKLED = 1 Then
                    FlipFlopQLED = 0
                    FlipFlopNOTQLED = 1
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 0 Then
                    FlipFlopQLED = 1
                    FlipFlopNOTQLED = 0
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 1 Then
                    Toggle(FlipFlopQLED)
                    Toggle(FlipFlopNOTQLED)
                EndIf
            EndIf 
            SRFlipFlopLED = 0
            JKFlipFlopLED = 1
            TFlipFlopLED = 0
            DFlipFlopLED = 0 
        Case 2
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                If FlipFlopSJTDLED = 0 Then
                    ' do nothing!
                Else
                    Toggle(FlipFlopQLED)
                    Toggle(FlipFlopNOTQLED)
                EndIf
            EndIf 
            SRFlipFlopLED = 0
            JKFlipFlopLED = 0
            TFlipFlopLED = 1
            DFlipFlopLED = 0 
        Case 3
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                FlipFlopQLED = FlipFlopSJTDLED
                FlipFlopNOTQLED = FlipFlopSJTDLED Xor %1
            EndIf 
            SRFlipFlopLED = 0
            JKFlipFlopLED = 0
            TFlipFlopLED = 0
            DFlipFlopLED = 1
    End Select    
End Sub

Sub DoCounter()
    DoButtonDebounce
    ' check the Up and Down buttons
    If CounterUp = 1 And CounterUpPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        CounterUpPressed = true
        Inc(CounterCount)
        If CounterCount > 15 Then
            CounterCount = 0
        EndIf
    ElseIf CounterUp = 0 Then
        CounterUpPressed = false
    EndIf 
    If CounterDown = 1 And CounterDownPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        CounterDownPressed = true
        Dec(CounterCount)
        If CounterCount = 255 Then
            CounterCount = 15
        EndIf
    ElseIf CounterDown = 0 Then
        CounterDownPressed = false
    EndIf
    ' Now display the count
    If WhichMode = 0 Or WhichMode = 1 Or WhichMode = 9 Then  ' we use this counter for mode select
        Counter8LED = CounterCount.bits(3)
        Counter4LED = CounterCount.bits(2)
        Counter2LED = CounterCount.bits(1)
        Counter1LED = CounterCount.bits(0) 
    ElseIf WhichMode = 2 Then               ' mode 2 is gray code
        TempByte = GrayCode(CounterCount)
        Counter8LED = TempByte.bits(3)
        Counter4LED = TempByte.bits(2)
        Counter2LED = TempByte.bits(1)
        Counter1LED = TempByte.bits(0)
    EndIf   
End Sub

Sub SaveLEDStates()
    PORTA.2 = LogicLEDs.bits(0)
    PORTA.3 = LogicLEDs.bits(1)
    PORTA.4 = LogicLEDs.bits(2)
    PORTA.5 = LogicLEDs.bits(3)
    PORTA.6 = LogicLEDs.bits(4)
    PORTA.7 = LogicLEDs.bits(5)
    PORTE.0 = LogicLEDs.bits(6)
    PORTE.1 = LogicLEDs.bits(7)
    PORTE.2 = LogicLEDs.bits(8)
    PORTC.0 = LogicLEDs.bits(9)
    PORTC.1 = LogicLEDs.bits(10)
    PORTC.2 = LogicLEDs.bits(11)
    PORTC.3 = LogicLEDs.bits(12)
    PORTC.4 = LogicLEDs.bits(13)
    PORTC.5 = LogicLEDs.bits(14)
    PORTD.0 = LogicLEDs.bits(15)
    PORTD.1 = LogicLEDs.bits(16)
    PORTD.2 = LogicLEDs.bits(17)
    PORTD.3 = LogicLEDs.bits(18)
    PORTD.4 = LogicLEDs.bits(19)
    PORTD.5 = LogicLEDs.bits(20)
    PORTD.6 = LogicLEDs.bits(21)
    PORTD.7 = LogicLEDs.bits(22)
End Sub

Sub ResetForMode1()
    ' variable setup 
    CounterCount = 0
    WhichLogicGate = 0 
    WhichFlipFlop = 0  
    CounterCount = 0  
    LogicInputAPressed = false  
    LogicInputBPressed = false   
    LogicSelectPressed = false   
    FlipFlopSJTDPressed = false   
    FlipFlopClockPressed = false   
    FlipFlopRKPressed = false   
    FlipFlopSelectPressed = false   
    CounterUpPressed = false   
    CounterDownPressed = false
    
    'port setup
    LogicInputALed = 0
    LogicInputBLed = 0
    NOTGateLED = 1
    ORGateLED = 0
    ANDGateLED = 0
    XORGateLED = 0
    NORGateLED = 0
    NANDGateLED = 0
    XNORGateLED = 0
    LogicGatesXLED = 1
    FlipFlopSJTDLED = 0
    FlipFlopClockLED = 0
    FlipFlopRKLED = 0
    SRFlipFlopLED = 1
    JKFlipFlopLED = 0
    TFlipFlopLED = 0
    DFlipFlopLED = 0
    FlipFlopQLED = 0 
    FlipFlopNOTQLED = 1 
    Counter8LED = 0 
    Counter4LED = 0 
    Counter2LED = 0 
    Counter1LED = 0  
    ClockEdge = false
End Sub

Sub ResetForMode0()
    ' variable setup
    CounterCount = 0
    WhichLogicGate = 1 
    WhichFlipFlop = 0  
    CounterCount = 0  
    LogicInputAPressed = false  
    LogicInputBPressed = false   
    LogicSelectPressed = false   
    FlipFlopSJTDPressed = false   
    FlipFlopClockPressed = false   
    FlipFlopRKPressed = false   
    FlipFlopSelectPressed = false   
    CounterUpPressed = false   
    CounterDownPressed = false
    
    'port setup
    LogicInputALed = 0
    LogicInputBLed = 0
    NOTGateLED = 0
    ORGateLED = 0
    ANDGateLED = 0
    XORGateLED = 0
    NORGateLED = 0
    NANDGateLED = 0
    XNORGateLED = 0
    LogicGatesXLED = 0
    FlipFlopSJTDLED = 0
    FlipFlopClockLED = 0
    FlipFlopRKLED = 0
    SRFlipFlopLED = 0
    JKFlipFlopLED = 0
    TFlipFlopLED = 0
    DFlipFlopLED = 0
    FlipFlopQLED = 0 
    FlipFlopNOTQLED = 0 
    Counter8LED = 0 
    Counter4LED = 0 
    Counter2LED = 0 
    Counter1LED = 0  
    ClockEdge = false
End Sub

Sub DoSparklyLEDs()
    SetRndMax(50)
    For x = 0 To 22 ' 23 LED's
        If rand = 0 Then
            LogicLEDs.bits(x) = 1
        Else
            LogicLEDs.bits(x) = 0
        EndIf
    Next
    SaveLEDStates
    DelayMS(SparkleDelay)
    ' check the Up and Down buttons  (to increase and decrease sparkle speed)
    If CounterUp = 1 And CounterUpPressed = false Then
        DelayMS(5)    ' this acts as a button debounce
        CounterUpPressed = true 
        If SparkleDelay <> 0 Then
            SparkleDelay = SparkleDelay - 10
        EndIf
    ElseIf CounterUp = 0 Then
        CounterUpPressed = false
    EndIf 
    If CounterDown = 1 And CounterDownPressed = false Then
        DelayMS(5)    ' this acts as a button debounce
        CounterDownPressed = true
        If SparkleDelay <> 250 Then
            SparkleDelay = SparkleDelay + 10
        EndIf
    ElseIf CounterDown = 0 Then
        CounterDownPressed = false
    EndIf
End Sub

Sub DoShiftRegister()   'mode 4 
    DoButtonDebounce   
    ' check input A button (this is the data input)
    If LogicInputA = 1 And LogicInputAPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputAPressed = true
        If LogicInputALed = 0 Then
            LogicInputALed = 1
        Else
            LogicInputALed = 0
        EndIf
    ElseIf LogicInputA = 0 Then
        LogicInputAPressed = false
    EndIf    
    ' check input B button (this is the reset input)
    If LogicInputB = 1 And LogicInputBPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputBPressed = true
        ShiftRegisterBuffer = 0
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf
    
    ' check the change gate button  (this is now our shift register clock)
    If LogicSelect = 1 And LogicSelectPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicSelectPressed = true
        ShiftRegisterBuffer = ShiftRegisterBuffer << 1
        ShiftRegisterBuffer.bits(0) = LogicInputALed
    ElseIf LogicSelect = 0 Then
        LogicSelectPressed = false
    EndIf
    '   send data to LED's
    NOTGateLED = ShiftRegisterBuffer.bits(0)
    ORGateLED = ShiftRegisterBuffer.bits(1)
    ANDGateLED = ShiftRegisterBuffer.bits(2)
    XORGateLED = ShiftRegisterBuffer.bits(3)
    NORGateLED = ShiftRegisterBuffer.bits(4)
    NANDGateLED = ShiftRegisterBuffer.bits(5)
    XNORGateLED = ShiftRegisterBuffer.bits(6)        
End Sub

Sub DoLightsTest()
    LogicLEDs = %11111111111111111111111111111111   'turn them all on
    SaveLEDStates
End Sub

Sub DoPOV()
    ' we don't want to use the default button debounce routine here because we have a delay of close to 1 millisecond in this routine!
    For x = (0 + (WhichPOVMessage * 200)) To ((WhichPOVMessage * 200) + 200)
        ShiftRegisterBuffer = POVMessage(x)
        '   send data to LED's
        NOTGateLED = ShiftRegisterBuffer.bits(6)
        ORGateLED = ShiftRegisterBuffer.bits(5)
        ANDGateLED = ShiftRegisterBuffer.bits(4)
        XORGateLED = ShiftRegisterBuffer.bits(3)
        NORGateLED = ShiftRegisterBuffer.bits(2)
        NANDGateLED = ShiftRegisterBuffer.bits(1)
        XNORGateLED = ShiftRegisterBuffer.bits(0)
        DelayUS(800) 
    Next
    ' check the Logic input b button  (to scroll through different POV messages)
    If LogicInputB = 1 And LogicInputBPressed = false Then
        DelayMS(100)    ' this just acts as a little debounce for the B button...
        LogicInputBPressed = true 
        Inc(WhichPOVMessage)
        If WhichPOVMessage = 3 Then
            WhichPOVMessage = 0
        EndIf
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf 
End Sub

Sub DoBinaryDice()
    DoButtonDebounce
    SetRndMax(6)
    ' check the Up button this will start the dice rolling
    If LogicInputB = 1 And LogicInputBPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputBPressed = true 
        DiceRolling = true
        DiceSpeedSaved = 0
        DiceSpeed = 0
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf
    
    If DiceRolling = true Then
        If DiceSpeed <> 0 Then
            Dec(DiceSpeed)
        Else
            Inc(DiceSpeedSaved)
            DiceSpeed = DiceSpeedSaved 
            DiceNumber = rand + 1   '(the random number is from 0 to 5, but we want from 1 to 6 so we add 1 
        EndIf
    EndIf
    If DiceSpeedSaved = 200 Then
        DiceRolling = false
    EndIf
    ' display on LEDs
    Counter8LED = DiceNumber.bits(3)
    Counter4LED = DiceNumber.bits(2)
    Counter2LED = DiceNumber.bits(1)
    Counter1LED = DiceNumber.bits(0)   
End Sub

Sub DoGame()
    DoButtonDebounce
    If GameSpeed <> 0 Then
        Dec(GameSpeed)
    Else
        ShiftRegisterBuffer = 0
        GameSpeed = (5000 - (GameLevel * 250)) ' the higher the number, the slower the game speed it keeps decreasing the number and increasing the speed the more points you get.
        If GameGoingUp = true Then
            Inc(GameLEDPosition)
            If GameLEDPosition = 7 Then
                GameLEDPosition = 5
                GameGoingUp = false
            EndIf
        Else
            Dec(GameLEDPosition)
            If GameLEDPosition = 255 Then
                GameLEDPosition = 1
                GameGoingUp = true
            EndIf
        EndIf
        ShiftRegisterBuffer.bits(GameLEDPosition) = 1
        
        '   send data to LED's
        NOTGateLED = ShiftRegisterBuffer.bits(6)
        ORGateLED = ShiftRegisterBuffer.bits(5)
        ANDGateLED = ShiftRegisterBuffer.bits(4)
        XORGateLED = ShiftRegisterBuffer.bits(3)
        NORGateLED = ShiftRegisterBuffer.bits(2)
        NANDGateLED = ShiftRegisterBuffer.bits(1)
        XNORGateLED = ShiftRegisterBuffer.bits(0)
    EndIf
    

    ' check the logic input B button which is our HIT button
    If LogicInputB = 1 And LogicInputBPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputBPressed = true
        If GameLEDPosition = 3 Then ' this means we have a hit!
            Inc(CounterCount)   ' this is actually our score
            Inc(GameLevel)    
        Else
            CounterCount = 0    ' reset the score and
            GameLevel = 0       ' the game level
        EndIf
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf 
    ' Now display the count
    Counter8LED = CounterCount.bits(3)
    Counter4LED = CounterCount.bits(2)
    Counter2LED = CounterCount.bits(1)
    Counter1LED = CounterCount.bits(0)      
End Sub

Sub Do4BitLogic()
    DoButtonDebounce 
    DoCounter
    ' check the change gate button
    If LogicSelect = 1 And LogicSelectPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicSelectPressed = true
        Inc(WhichLogicGate)
        If WhichLogicGate > 6 Or WhichLogicGate = 0 Then    'we need to get rid of the 0 possibility because you can't do this with a not gate!
            WhichLogicGate = 1
        EndIf
    ElseIf LogicSelect = 0 Then
        LogicSelectPressed = false
    EndIf  
    ' check inputA button, this loads data into logicinput0
    If LogicInputA = 1 And LogicInputAPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputAPressed = true
            LogicInput0 = CounterCount
    ElseIf LogicInputA = 0 Then
        LogicInputAPressed = false
    EndIf   
    ' check inputB button, this loads data into logicinput1
    If LogicInputB = 1 And LogicInputBPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime
        ButtonsEnabled = false
        LogicInputBPressed = true
        LogicInput1 = CounterCount
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf
    'now do the logic calculation!
    Select WhichLogicGate   
        Case 1
            LogicAnswer = LogicInput0 Or LogicInput1
            NOTGateLED = 0
            ORGateLED = 1
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 2
            LogicAnswer = LogicInput0 And LogicInput1
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 1
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 3
            LogicAnswer = LogicInput0 Xor LogicInput1
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 1
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 4
            LogicAnswer = (LogicInput0 Or LogicInput1) Xor %11111111
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 1
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 5
            LogicAnswer = (LogicInput0 And LogicInput1) Xor %11111111
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 1
            XNORGateLED = 0 
        Case 6
            LogicAnswer = (LogicInput0 Xor LogicInput1) Xor %11111111
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 1
    End Select
    SRFlipFlopLED = LogicAnswer.bits(3)
    JKFlipFlopLED = LogicAnswer.bits(2)
    TFlipFlopLED = LogicAnswer.bits(1)
    DFlipFlopLED = LogicAnswer.bits(0) 
    
End Sub

Sub DoModeSelect()
    DoButtonDebounce
    DoCounter
    ' check input B button (this is our enter button to choose a desired mode)
    If LogicInputB = 1 And LogicInputBPressed = false And ButtonsEnabled = true Then
        ButtonDebounce = BtnDebounceTime            
        ButtonsEnabled = false
        WhichMode = CounterCount
        If WhichMode = 1 Or WhichMode = 2 Then  'this is stock standard mode (1) or gray code (2)
            ResetForMode1
        ElseIf WhichMode > 2 Then  ' turn off all LED's
            ResetForMode0
        EndIf
    EndIf
End Sub

' Start Of Program - this is where we setup everything before getting into the main loop

' Oscillator setup
OSCCON = %01100000          ' device enters sleep on IDLE, 8Mhz Clock,   
OSCTUNE = %00000000         ' Internal oscillator low freq comes from 31Khz clock from LFINTOSC, PLL disabled

' Analog / Digital pins setup
ANSEL = %00000000          ' disable all analog inputs (make them all digital) must do this!
ANSELH = %00000000         ' disable all analog inputs (make them all digital) must do this!

' Tristate setup
TRISA = %00000011
TRISB = %11111110
TRISC = %00000000
TRISD = %00000000
TRISE = %00000000

ButtonDebounce = BtnDebounceTime
SetRndMax(50)
SparkleDelay = 20
ShiftRegisterBuffer = 0
WhichPOVMessage = 0
GameSpeedSaved = 50
GameSpeed = GameSpeedSaved
GameLevel = 0
GameGoingUp = true
GameLEDPosition = 1
LogicInput0 = 0
LogicInput1 = 0
LogicAnswer = 0

If LogicInputA = 1 Then
    WhichMode = 0   'This puts it into mode select mode (you select the mode with the up/down arrows on the counter then press logic input b to enter that mode)
    ResetForMode0
Else
    WhichMode = 1   ' this is the stock standard DigiRule mode - as advertised in the original video!
    ResetForMode1
EndIf

While true()
    If WhichMode = 0 Then
        DoModeSelect            ' allow the user to select a desired mode
    ElseIf WhichMode = 1 Or WhichMode = 2 Then   ' stock standard mode (as advetised originally) or gray code mode (the only difference is that the counter is now gray code rather than binary)
        DoLogicGates    
        DoFlipFlops
        DoCounter
    ElseIf WhichMode = 3 Then   'sparkly LED's up and down arrows change speed
        DoSparklyLEDs
    ElseIf WhichMode = 4 Then   ' seven bit shift register on LOGIC gate LED's A button = input data, B = reset Gate Select = Clock
        DoShiftRegister
    ElseIf WhichMode = 5 Then
        DoLightsTest            ' turns all LED's on
    ElseIf WhichMode = 6 Then
        DoPOV                   ' display a Persistance of Vision Message
    ElseIf WhichMode = 7 Then
        DoBinaryDice            ' a 1 to 6 random number generator
    ElseIf WhichMode = 8 Then
        DoGame
    ElseIf WhichMode = 9 Then
        Do4BitLogic
    EndIf 
Wend            












 

 

 
 
